/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.ritual.imperfect.ImperfectRitual;
import wayoftime.bloodmagic.util.BMLog;

public class RitualManager {
    public static final DamageSource RITUAL_DAMAGE = new DamageSource("ritual_damage").m_19380_();
    private final Map<String, Ritual> rituals = Maps.newTreeMap();
    private final Map<Ritual, String> ritualsReverse = Maps.newHashMap();
    private final List<Ritual> sortedRituals = Lists.newArrayList();
    private final Map<String, ImperfectRitual> imperfectRituals = Maps.newTreeMap();
    private final Map<ImperfectRitual, String> imperfectRitualsReverse = Maps.newHashMap();

    public void discover() {
        ModList.get().getAllScanData().forEach(scan -> scan.getAnnotations().forEach(a -> {
            if (a.annotationType().getClassName().equals(RitualRegister.class.getName())) {
                try {
                    Class<?> clazz = Class.forName(a.clazz().getClassName());
                    RitualRegister ritualRegister = clazz.getAnnotation(RitualRegister.class);
                    String id = ritualRegister.value();
                    if (Ritual.class.isAssignableFrom(clazz)) {
                        Ritual ritual = (Ritual)clazz.newInstance();
                        this.rituals.put(id, ritual);
                        this.ritualsReverse.put(ritual, id);
                        BMLog.DEBUG.info("Registered ritual {}", id);
                    } else {
                        BMLog.DEFAULT.error("Error creating ritual instance for {}.", id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        ModList.get().getAllScanData().forEach(scan -> scan.getAnnotations().forEach(a -> {
            if (a.annotationType().getClassName().equals(RitualRegister.Imperfect.class.getName())) {
                try {
                    Class<?> clazz = Class.forName(a.annotationType().getClassName());
                    RitualRegister.Imperfect ritualRegister = clazz.getAnnotation(RitualRegister.Imperfect.class);
                    String id = ritualRegister.value();
                    if (ImperfectRitual.class.isAssignableFrom(clazz)) {
                        ImperfectRitual ritual = (ImperfectRitual)clazz.newInstance();
                        this.imperfectRituals.put(id, ritual);
                        this.imperfectRitualsReverse.put(ritual, id);
                        BMLog.DEBUG.info("Registered imperfect ritual {}", id);
                    } else {
                        BMLog.DEFAULT.error("Error creating imperfect ritual instance for {}.", id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        this.sortedRituals.addAll(this.rituals.values());
        this.sortedRituals.sort((o1, o2) -> {
            HashSet components = Sets.newHashSet();
            o1.gatherComponents(components::add);
            int initialSize = components.size();
            components.clear();
            o2.gatherComponents(components::add);
            return Integer.compare(initialSize, components.size());
        });
    }

    public Ritual getRitual(String id) {
        Ritual ritual = this.rituals.get(id);
        return ritual == null ? null : ritual.getNewCopy();
    }

    public String getId(Ritual ritual) {
        return this.ritualsReverse.get(ritual);
    }

    public ImperfectRitual getImperfectRitual(BlockState state) {
        for (ImperfectRitual ritual : this.imperfectRituals.values()) {
            if (!ritual.getBlockRequirement().test(state)) continue;
            return ritual;
        }
        return null;
    }

    public String getId(ImperfectRitual ritual) {
        return this.imperfectRitualsReverse.get(ritual);
    }

    public Collection<Ritual> getRituals() {
        return this.rituals.values();
    }

    public Collection<ImperfectRitual> getImperfectRituals() {
        return this.imperfectRituals.values();
    }

    public List<Ritual> getSortedRituals() {
        return this.sortedRituals;
    }

    public boolean enabled(String id, boolean imperfect) {
        return id != null;
    }

    public static class BadRitualException
    extends RuntimeException {
        public BadRitualException(String message) {
            super(message);
        }
    }
}

